/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.stateinfo.additional;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.api.variant.state.IStateVariantProvider;
import mod.chiselsandbits.platforms.core.fluid.FluidInformation;
import mod.chiselsandbits.platforms.core.registries.IPlatformRegistryManager;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import org.jetbrains.annotations.NotNull;

public final class StateVariantManager
implements IStateVariantManager {
    private static final StateVariantManager INSTANCE = new StateVariantManager();
    private final Map<class_2248, IStateVariantProvider> providers = new ConcurrentHashMap<class_2248, IStateVariantProvider>();

    public static StateVariantManager getInstance() {
        return INSTANCE;
    }

    private StateVariantManager() {
    }

    @Override
    public Optional<IStateVariant> getStateVariant(class_2680 blockState, Optional<class_2586> blockEntity) {
        if (!this.providers.containsKey(blockState.method_26204())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(blockState.method_26204())).flatMap(provider -> provider.getStateVariant(blockState, blockEntity)).map(variant -> new WrappingStateVariant(blockState.method_26204(), (IStateVariant)variant));
    }

    @Override
    public Optional<IStateVariant> getStateVariant(class_3610 fluidStateIn) {
        if (!this.providers.containsKey(fluidStateIn.method_15759().method_26204())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(fluidStateIn.method_15759().method_26204())).flatMap(provider -> provider.getStateVariant(fluidStateIn)).map(variant -> new WrappingStateVariant(fluidStateIn.method_15759().method_26204(), (IStateVariant)variant));
    }

    @Override
    public Optional<IStateVariant> getStateVariant(class_2680 blockState, class_1799 itemStack) {
        if (!this.providers.containsKey(blockState.method_26204())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(blockState.method_26204())).flatMap(provider -> provider.getStateVariant(blockState, itemStack)).map(variant -> new WrappingStateVariant(blockState.method_26204(), (IStateVariant)variant));
    }

    @Override
    public Optional<IStateVariant> getStateVariant(FluidInformation fluidInformation) {
        if (!this.providers.containsKey(fluidInformation.fluid().method_15785().method_15759().method_26204())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(fluidInformation.fluid().method_15785().method_15759().method_26204())).flatMap(provider -> provider.getStateVariant(fluidInformation)).map(variant -> new WrappingStateVariant(fluidInformation.fluid().method_15785().method_15759().method_26204(), (IStateVariant)variant));
    }

    @Override
    public Collection<BlockInformation> getAllDefaultVariants(class_2680 state) {
        if (!this.providers.containsKey(state.method_26204())) {
            return Collections.emptyList();
        }
        return Optional.of(this.providers.get(state.method_26204())).map(provider -> provider.getAllDefaultVariants(state)).stream().flatMap(Collection::stream).map(variant -> new WrappingStateVariant(state.method_26204(), (IStateVariant)variant)).map(variant -> new BlockInformation(state, Optional.ofNullable(variant))).collect(Collectors.toSet());
    }

    @Override
    public class_2487 serializeNBT(IStateVariant additionalStateInfo) {
        if (!(additionalStateInfo instanceof WrappingStateVariant)) {
            throw new IllegalArgumentException("additionalStateInfo must be a WrappingStateVariant");
        }
        WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)additionalStateInfo;
        class_2248 block = wrappingStateVariant.getSourceBlock();
        class_2487 tag = new class_2487();
        tag.method_10582("block", IPlatformRegistryManager.getInstance().getBlockRegistry().getKey(block).toString());
        tag.method_10566("variant", (class_2520)this.providers.get(block).serializeNBT(wrappingStateVariant.getDelegate()));
        return tag;
    }

    @Override
    public IStateVariant deserializeNBT(class_2487 tag) {
        Optional<class_2248> block = IPlatformRegistryManager.getInstance().getBlockRegistry().getValue(new class_2960(tag.method_10558("block")));
        if (block.isEmpty()) {
            throw new IllegalStateException("Missing block from variant!");
        }
        IStateVariant delegate = this.providers.get(block.get()).deserializeNBT(tag.method_10562("variant"));
        return new WrappingStateVariant(block.get(), delegate);
    }

    @Override
    public void serializeInto(class_2540 packetBuffer, IStateVariant info) {
        if (!(info instanceof WrappingStateVariant)) {
            throw new IllegalArgumentException("additionalStateInfo must be a WrappingStateVariant");
        }
        WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)info;
        packetBuffer.method_10812(IPlatformRegistryManager.getInstance().getBlockRegistry().getKey(wrappingStateVariant.getSourceBlock()));
        this.providers.get(wrappingStateVariant.getSourceBlock()).serializeInto(packetBuffer, wrappingStateVariant.getDelegate());
    }

    @Override
    public IStateVariant deserializeFrom(class_2540 packetBuffer) {
        Optional<class_2248> block = IPlatformRegistryManager.getInstance().getBlockRegistry().getValue(packetBuffer.method_10810());
        if (block.isEmpty()) {
            throw new IllegalStateException("Missing block from variant!");
        }
        IStateVariant stateVariant = this.providers.get(block.get()).deserializeFrom(packetBuffer);
        return new WrappingStateVariant(block.get(), stateVariant);
    }

    @Override
    public Optional<class_1799> getItemStack(BlockInformation blockInformation) {
        if (!this.providers.containsKey(blockInformation.getBlockState().method_26204())) {
            return Optional.empty();
        }
        return this.providers.get(blockInformation.getBlockState().method_26204()).getItemStack(blockInformation.getVariant());
    }

    @Override
    public Optional<FluidInformation> getFluidInformation(BlockInformation state, long amount) {
        if (!this.providers.containsKey(state.getBlockState().method_26204())) {
            return Optional.empty();
        }
        return this.providers.get(state.getBlockState().method_26204()).getFluidInformation(state.getVariant(), amount);
    }

    private static final class WrappingStateVariant
    implements IStateVariant {
        private static final Comparator<IStateVariant> VARIANT_COMPARATOR = Comparator.comparing(variant -> variant.getClass().getName()).thenComparing(Comparator.naturalOrder());
        private final class_2248 sourceBlock;
        private final IStateVariant delegate;

        private WrappingStateVariant(class_2248 sourceBlock, IStateVariant delegate) {
            this.sourceBlock = sourceBlock;
            this.delegate = delegate;
        }

        @Override
        public int compareTo(@NotNull IStateVariant o) {
            if (o instanceof WrappingStateVariant) {
                WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)o;
                return VARIANT_COMPARATOR.compare(this.delegate, wrappingStateVariant.delegate);
            }
            return -1;
        }

        @Override
        public IStateVariant createSnapshot() {
            return new WrappingStateVariant(this.sourceBlock, (IStateVariant)this.delegate.createSnapshot());
        }

        public class_2248 getSourceBlock() {
            return this.sourceBlock;
        }

        public IStateVariant getDelegate() {
            return this.delegate;
        }
    }
}

